/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Waveform Genration
/* - Contents:   COMI-SD301  D/A CH0 Ͽ 
/*     5Volt Amplitude 1KHz ļ  Sine wave ȣ 
/*	   ߻Ű Դϴ.   Sine waveȣ 
/*	   1000 ֱ⾿  ߻ŵϴ. , 1000ֱ Sine waveȣ
/*       1  ٽ 1000ֱ Sine waveȣ մϴ.
/*
/* - Remarks : 
/*     1.   COMI-SD301 忡 밡մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD301
#define CHAN	0
#define AMP		5  // AMPLITUDE
#define FREQ	1000 // FREQUENCY
#define N		50

void main (void)
{
	HANDLE hDevice;
	float fWaveBuf[N], rad;
	long nCount;

	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}
	
	rad = 2*3.141592f/N;
	for(int i=0; i<N; i++)
		fWaveBuf[i] = AMP * sin(i*rad);

	printf("Waveform Generation Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
		
	while (!_kbhit()){
		COMI_WFM_Start(hDevice, CHAN, fWaveBuf, N, N*FREQ, 1000);
		printf("Waveform Generation has started!\n");
		while((nCount = COMI_WFM_GetCurLoops(hDevice, CHAN)) > 0){
			printf("Remainning Loops = %d\n", nCount);
		}
		printf("Waveform Generation has finished!");
		Sleep(1000);
	}
	COMI_WFM_Stop(hDevice, CHAN);
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
